<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $__env->yieldContent('title'); ?> - Your Server Name</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary-color: #4B8BFF;
            --primary-dark: #2970e6;
            --primary-light: #a2c3ff;
            
            --dark-gray: #1E1E1E;
            --dark-gray-lighter: #2A2A2A;
            --dark-gray-lightest: #333333;
            --mid-gray: #606060;
            --light-gray: #9A9A9A;
            --lighter-gray: #E0E0E0;
            
            --white: #FFFFFF;
            --black: #000000;
            
            --success: #4CD964;
            --warning: #FFC107;
            --danger: #FF3B30;
            --info: #5AC8FA;
            
            --steam-color: #171a21;
            
            --font-family-base: 'Poppins', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Helvetica, Arial, sans-serif;
            --font-size-base: 16px;
            --line-height-base: 1.6;
            
            --spacing-xs: 0.25rem;
            --spacing-sm: 0.5rem;
            --spacing-md: 1rem;
            --spacing-lg: 1.5rem;
            --spacing-xl: 2rem;
            --spacing-xxl: 3rem;
            
            --border-radius-sm: 0.25rem;
            --border-radius-md: 0.5rem;
            --border-radius-lg: 0.75rem;
            --border-radius-xl: 1rem;
            
            --box-shadow-sm: 0 2px 4px rgba(0, 0, 0, 0.05);
            --box-shadow-md: 0 4px 8px rgba(0, 0, 0, 0.1);
            --box-shadow-lg: 0 6px 16px rgba(0, 0, 0, 0.1);
            
            --transition-base: all 0.3s ease;
            --transition-fast: all 0.15s ease;
        }
        
        *,
        *::before,
        *::after {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }
        
        html {
            font-size: var(--font-size-base);
            height: 100%;
        }
        
        body {
            font-family: var(--font-family-base);
            font-size: 1rem;
            font-weight: 400;
            line-height: var(--line-height-base);
            color: var(--white);
            background-color: var(--dark-gray);
            min-height: 100%;
        }
        
        a {
            color: var(--primary-color);
            text-decoration: none;
            transition: var(--transition-base);
        }
        
        a:hover {
            color: var(--primary-light);
        }
        
        .d-flex {
            display: flex;
        }
        
        .align-items-center {
            align-items: center;
        }
        
        .mx-sm {
            margin-left: var(--spacing-sm);
            margin-right: var(--spacing-sm);
        }
        
        .ml-md {
            margin-left: var(--spacing-md);
        }
        
        .small {
            font-size: 0.875rem;
        }
        
        .text-secondary {
            color: var(--light-gray);
        }
        
        .text-primary {
            color: var(--primary-color);
        }
    </style>
    <?php echo $__env->yieldContent('styles'); ?>
</head>
<body>
    <?php echo $__env->yieldContent('content'); ?>
    <?php echo $__env->yieldContent('scripts'); ?>
</body>
</html><?php /**PATH /var/www/siedestudios.co.uk/edge/resources/views/layouts/minimal.blade.php ENDPATH**/ ?>